#!/bin/bash

# Setup my environment
#. ${SCRIPTS_HOME}/${DOMAIN_NAME}.profile
. /vagrant/shell/portal-admin/portal.dev.profile

# Check to see whether jRebel configuration has already been created. If 
# it has not, then create it.
echo "Checking existence of JRebel folder: /u01/app/domains/${DOMAIN_NAME}/lib"
if [ ! -d "/u01/app/liferay-portal-6.2-ee-sp14/tomcat-7.0.62/lib/jrebel" ]; then
        echo "Could not find JRebel installation; Logging in as Liferay and installing JRebel within ${LIFERAY_TOMCAT_HOME}/lib"
	echo "Downloading the latest JRebel zip file from Zeroturnaround website..."
        sudo su - liferay -c "cd ${LIFERAY_TOMCAT_HOME}/lib/; wget http://dl.zeroturnaround.com/jrebel-stable-nosetup.zip"
        #echo "Downloading the required JRebel zip file from cm82..."
        #sudo su - liferay -c "cd ${LIFERAY_TOMCAT_HOME}/lib/; wget http://DNS/tools/jrebel/jrebel-stable-nosetup.zip"
	echo "Unzipping the JRebel zip file as liferay user"
	sudo su - liferay -c "cd ${LIFERAY_TOMCAT_HOME}/lib/; /usr/bin/unzip -q jrebel-stable-nosetup.zip"
	echo "Removing JRebel setup zip file"
        sudo su - liferay -c "rm -rf ${LIFERAY_TOMCAT_HOME}/lib/jrebel-stable-nosetup.zip"
	echo "Copying the setenv based JRebel file to bin directory"
	sudo su - liferay -c "cp /vagrant/shell/portal-admin/tomcat-setenvWithJRebel.sh ${LIFERAY_TOMCAT_HOME}/bin/setenv.sh"
	echo "Restarting Tomcat"
        sudo su - liferay -c "$LIFERAY_TOMCAT_HOME/bin/catalina.sh jpda start"
fi
	echo "Found JRebel installation; Skipping JRebel setup"
